﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI.WebControls;

using VIRP.CRS.BLL;
using VIRP.CRS.BO;
using VIRP.EFR.BLL;
using VIRP.EFR.BO;
using VIRP.EFR.UTIL;

namespace VIRP_WEB.Custom.EFR
{
    public partial class EventReminders : EfrBasePage
    {
        protected override void Page_Load(object sender, EventArgs e)
        {
            ReplacePageTitle();

            SetupCommonDataSourceParameters();

            // Added for 508 compliance with GridView column headers and footer
            Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + GridViewReferralEventReminders.ClientID + "');", true);
        }

        private void SetupCommonDataSourceParameters()
        {
            var currentUser = HttpContext.Current.User.Identity.Name;
            ObjectDataSourceEventReminders.SelectParameters["CURRENT_USER"].DefaultValue = currentUser;
            ObjectDataSourceSnoozeDurations.SelectParameters["CURRENT_USER"].DefaultValue = currentUser;

            var currentRegistry = UserSession.CurrentRegistryId.ToString();
            ObjectDataSourceEventReminders.SelectParameters["CURRENT_REGISTRY_ID"].DefaultValue = currentRegistry;
            ObjectDataSourceSnoozeDurations.SelectParameters["CURRENT_REGISTRY_ID"].DefaultValue = currentRegistry;
        }

        public void EventReminders_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Details")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewReferralEventReminders.SelectedIndex = index;

                // Calling the right page for different order lab order type
                Label fUpType = GridViewReferralEventReminders.SelectedRow.FindControl("LabelFollowupType") as Label;
                if (fUpType != null)
                {
                    if (fUpType.Text.Equals("Biomonitoring"))
                    {
                        int id = int.Parse(GridViewReferralEventReminders.SelectedDataKey["ReferralId"].ToString());
                        Response.Redirect(string.Format("~/Custom/EFR/Referrals/Referral.aspx?referralId={0}", id), false);
                        //Response.Redirect($"~/Custom/EFR/Referrals/Referral.aspx?referralId={id}", false);
                    }
                    else if (fUpType.Text.Equals("Contact"))
                    {
                        int referralId = int.Parse(GridViewReferralEventReminders.SelectedDataKey["ReferralId"].ToString());
                        int contactId = int.Parse(GridViewReferralEventReminders.SelectedDataKey["ContactId"].ToString());

                        Response.Redirect(string.Format("~/Custom/EFR/Referrals/ReferralContact.aspx?referralId={0}&contactId={1}", referralId, contactId), false);
                        //Response.Redirect($"~/Custom/EFR/Referrals/ReferralContact.aspx?referralId={referralId}&contactId={contactId}", false);
                    }
                }
            }
            else if (e.CommandName == "Snooze")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewReferralEventReminders.SelectedIndex = index;

                // Calling the right page for different order lab order type
                Label fUpType = GridViewReferralEventReminders.SelectedRow.FindControl("LabelFollowupType") as Label;
                if (fUpType != null)
                {
                    if (fUpType.Text.Equals("Biomonitoring"))
                        HandleBiomonitoring();
                    else if (fUpType.Text.Equals("Contact"))
                        HandleContact();
                }
            }

            // Re-bind gridview
            GridViewReferralEventReminders.DataBind();
        }

        private void HandleBiomonitoring()
        {
            int activityId = int.Parse(GridViewReferralEventReminders.SelectedDataKey["ActivityId"].ToString());
            WKF_CASE_ACTIVITY activity = WKF_CASE_ACTIVITYManager.GetItem(CurrentUser, CurrentRegistryId, activityId);

            activity = SerializerUtility.Deserialize<WKF_CASE_ACTIVITY>(activity.Serialize());

            DropDownList ddlPeriod = GridViewReferralEventReminders.SelectedRow.FindControl("DropDownSnoozeDurations") as DropDownList;

            if (ddlPeriod != null)
            {
                if (ddlPeriod.SelectedIndex == 1)
                    activity.FOLLOWUP_REMINDER_DATE = DateTime.Today.AddDays(1);
                else if (ddlPeriod.SelectedIndex == 2)
                    activity.FOLLOWUP_REMINDER_DATE = DateTime.Today.AddDays(3);
                else if (ddlPeriod.SelectedIndex == 3)
                    activity.FOLLOWUP_REMINDER_DATE = DateTime.Today.AddDays(7);
                else if (ddlPeriod.SelectedIndex == 4)
                    activity.FOLLOWUP_REMINDER_DATE = DateTime.Today.AddDays(14);
                else if (ddlPeriod.SelectedIndex == 5)
                    activity.FOLLOWUP_REMINDER_DATE = DateTime.Today.AddMonths(1);
            }

            WKF_CASE_ACTIVITYManager.Save(CurrentUser, CurrentRegistryId, activity);

            GridViewReferralEventReminders.SelectedIndex = -1;
        }

        private void HandleContact()
        {
            int contactId = int.Parse(GridViewReferralEventReminders.SelectedDataKey["ContactId"].ToString());

            CONTACT_LOG contact = CONTACT_LOGManager.GetItem(CurrentUser, CurrentRegistryId, contactId);

            //have to serialize to avoid linq attach exception
            contact = SerializerUtility.Deserialize<CONTACT_LOG>(contact.Serialize());

            DropDownList ddlPeriod = GridViewReferralEventReminders.SelectedRow.FindControl("DropDownSnoozeDurations") as DropDownList;

            if (ddlPeriod != null)
            {
                if (ddlPeriod.SelectedIndex == 1)
                    contact.DATE_REMIND_ME_ON = DateTime.Today.AddDays(1);
                else if (ddlPeriod.SelectedIndex == 2)
                    contact.DATE_REMIND_ME_ON = DateTime.Today.AddDays(3);
                else if (ddlPeriod.SelectedIndex == 3)
                    contact.DATE_REMIND_ME_ON = DateTime.Today.AddDays(7);
                else if (ddlPeriod.SelectedIndex == 4)
                    contact.DATE_REMIND_ME_ON = DateTime.Today.AddDays(14);
                else if (ddlPeriod.SelectedIndex == 5)
                    contact.DATE_REMIND_ME_ON = DateTime.Today.AddMonths(1);
            }

            CONTACT_LOGManager.Save(CurrentUser, CurrentRegistryId, contact);
        }

        protected void EventReminders_Selected(object sender, ObjectDataSourceStatusEventArgs e)
        {
            if (e.ReturnValue is List<ReferralFollowUp>)
            {
                List<ReferralFollowUp> list = e.ReturnValue as List<ReferralFollowUp>;

                if (list != null)
                {
                    if (list.Count == 0)
                        Response.Redirect("~/Custom/EFR/Patients/Patients.aspx", false);
                }
            }
        }
    }
}